from argparse import ArgumentParser
from reveallldb.protocols.command_class import CommandClass
from typing import List

def RevealCommandArgumentParser() -> ArgumentParser:
    parser = ArgumentParser(
        prog='reveal', 
        description='Commands for loading and controlling Reveal Server in the current debugging session.',
        add_help=False
    )

    subparsers = parser.add_subparsers(title='actions', description='valid actions')

    # Register all classes that have a register_lldb_command method. We do this lazily here to avoid circular imports.
    from reveallldb.commands.load import LoadCommand
    from reveallldb.commands.start import StartCommand
    from reveallldb.commands.stop import StopCommand
    from reveallldb.commands.status import StatusCommand

    commands: List[CommandClass] = [
        LoadCommand(parser),
        StartCommand(parser),
        StopCommand(parser),
        StatusCommand(parser)
    ]

    subparsersMap = {}
    for command in commands:
        subparser = subparsers.add_parser(command.program, help=command.description)
        subparser.set_defaults(func=command.handle_command)
        subparsersMap[command.program] = subparser

    # This is not great - the registration of this argument should be done within the command itself
    subparsersMap[LoadCommand.program].add_argument(
        "-a", 
        "--autostart", 
        action="store_true", 
        help="Automatically start Reveal Server after loading.")
    
    return parser
