from argparse import ArgumentParser, Namespace
from lldb import SBDebugger, SBExecutionContext, SBCommandReturnObject
from reveallldb.reveal_loader import RevealLoader

class LoadCommand:
    program = 'load'
    description = 'Loads Reveal Server into the current target.'

    def __init__(self, parser: ArgumentParser):
        self.parser = parser

    def handle_command(self, loader: RevealLoader, args: Namespace, debugger: SBDebugger, command, exe_ctx: SBExecutionContext, result: SBCommandReturnObject):
        loader.setup_legacy_breakpoints_if_necessary(args.autostart, result)
        loader.inject_server(result)

        # If injection succeeded and autostart option is specified, start the server
        if result.Succeeded() and args.autostart == True:
            loader.start_server(result)

