from argparse import ArgumentParser, Namespace
from lldb import SBDebugger, SBExecutionContext, SBCommandReturnObject
from reveallldb.reveal_loader import RevealLoader

class StatusCommand:
    program = 'status'
    description = 'Print the current status of Reveal Server.'

    def __init__(self, parser: ArgumentParser):
        self.parser = parser

    def handle_command(self, loader: RevealLoader, args: Namespace, debugger: SBDebugger, command, exe_ctx: SBExecutionContext, result: SBCommandReturnObject):
        if loader.is_server_loaded():
            version = loader.server_protocol_version()
            if loader.is_server_running():
                result.AppendMessage("Reveal Server (protocol version {0}) is loaded and running.".format(version))
            else:
                result.AppendMessage("Reveal Server (protocol version {0}) is loaded, but not running.".format(version))
        else:
            result.AppendMessage("Reveal Server is not loaded.")

