from argparse import ArgumentParser, Namespace
from lldb import SBDebugger, SBExecutionContext, SBCommandReturnObject
from reveallldb.reveal_loader import RevealLoader

class StopCommand:
    program = 'stop'
    description = 'Stop Reveal Server, if it is running.'

    def __init__(self, parser: ArgumentParser):
        self.parser = parser

    def handle_command(self, loader: RevealLoader, args: Namespace, debugger: SBDebugger, command, exe_ctx: SBExecutionContext, result: SBCommandReturnObject):
        loader.stop_server(result)



