from enum import Enum, EnumMeta

class MetaEnum(EnumMeta):
    def __contains__(cls, item):
        try:
            cls(item) # type: ignore
        except ValueError:
            return False
        return True    

class BaseEnum(Enum, metaclass=MetaEnum):
    pass
