from argparse import ArgumentParser, Namespace
from lldb import SBCommandReturnObject, SBDebugger, SBExecutionContext
from reveallldb.reveal_loader import RevealLoader
from typing import Protocol, runtime_checkable

@runtime_checkable
class CommandClass(Protocol):
    program: str
    description: str

    def __init__(self, parser: ArgumentParser):
        pass

    def handle_command(self, loader: RevealLoader, args: Namespace, debugger: SBDebugger, command, exe_ctx: SBExecutionContext, result: SBCommandReturnObject):
        pass
