from reveallldb.supported_target import SupportedTarget
from reveallldb.supported_architecture import SupportedArchitecture
from reveallldb.supported_platform import SupportedPlatform
from reveallldb.supported_platform_variant import SupportedPlatformVariant

def test_supported_target():
	target_triples_and_values = [
		("arm64-apple-ios15.0.0", SupportedTarget(SupportedArchitecture.arm64, SupportedPlatform.iOS, None)),
		("x86_64-apple-ios-simulator", SupportedTarget(SupportedArchitecture.x86_64, SupportedPlatform.iOS, SupportedPlatformVariant.simulator)),
		("x86_64-apple-ios14.0.0-simulator", SupportedTarget(SupportedArchitecture.x86_64, SupportedPlatform.iOS, SupportedPlatformVariant.simulator)),
		("arm64-apple-ios15.5.0-simulator", SupportedTarget(SupportedArchitecture.arm64, SupportedPlatform.iOS, SupportedPlatformVariant.simulator)),
		("x86_64-apple-ios14.2.0-macabi", SupportedTarget(SupportedArchitecture.x86_64, SupportedPlatform.iOS, SupportedPlatformVariant.macCatalyst)),
		("some.completely!invalid#triple", None),
		("x86_64-linux-gnu", None),
	]

	for (triple, expected_target) in target_triples_and_values:
		target = SupportedTarget.from_lldb_target_triple(triple)
		assert target == expected_target

# This reflect the current root directory structure of the XCFramework
framework_variants = [
	'_CodeSignature',
	'tvos-arm64',
	'tvos-arm64_x86_64-simulator',
	'ios-arm64_x86_64-simulator',
	'ios-arm64_x86_64-maccatalyst',
	'Scripts',
	'ios-arm64'
]

def test_revealloader_framework_slice_for_device_target_process():
    target = SupportedTarget(SupportedArchitecture.arm64, SupportedPlatform.iOS, None)
    slice = target.framework_slice(framework_variants)
    assert slice == 'ios-arm64'

def test_revealloader_framework_slice_for_simulator_target_process():
    target = SupportedTarget(SupportedArchitecture.arm64, SupportedPlatform.iOS, SupportedPlatformVariant.simulator)
    slice = target.framework_slice(framework_variants)
    assert slice == 'ios-arm64_x86_64-simulator'

def test_revealloader_framework_slice_for_catalyst_target_process():
    target = SupportedTarget(SupportedArchitecture.arm64, SupportedPlatform.iOS, SupportedPlatformVariant.macCatalyst)
    slice = target.framework_slice(framework_variants)
    assert slice == 'ios-arm64_x86_64-maccatalyst'
